//***********************************************************************
//*                 1602 (4002)             *
//----------------------------------------------------------------------*
//*            *
//*          40  60 *
//*    (     ),    *
//*    c       *
//*                            (C) .                             *
//*                         V2.0  17.02.2016                          *
//*                         V2.1  05.06.2016                          *
//*                         V3.0  16.05.2017                          *
//*                         V4.0  11.07.2017                          *
//*                         V4.1  03.08.2017                          *
//*                         V4.2  04.08.2017                          *
//*                         V5.0  16.06.2018                          *
//----------------------------------------------------------------------*
//*                     AVR Studio V4.19 Build 730                      *
//***********************************************************************
//  ATmega8   : 8 
//Low Fuse:  24
//High Fuse: D1
//        
// :
//PD1..PD4, PC5 (RS), PC4 (E), PD0 (RW) -   4- 
//PC3 (ADC3) -     
//PC0 (ADC0) -     
//PB1 -    ()  40/60 
//      (  -  ,  )
//PB2 -       / 
//PB6 -      (   4.1)
//PB5, PB4, PB3 -  "-", "Sel", "+"     


#define lcd4002 //  4002  40  ( ,  1602  16)
//#define rus4002 //      4002 ( ,  en)

//   60   
//    (1024 )

//  5.0  1602    4002,   
//      5   4/5,
//    (    ),
//      : 40  60 ;
//   4002    ( 6 ).
//    40/60    4002    !!!

//   4.1:       
//(  8  9 ),    ,     
// ,    / 
//  1602:
//     20  28   ()  .
//  4002 (,    5.0):
//     66/64  76   ()  .


#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <avr/eeprom.h>
#include <math.h>   // libm.a   Libraries   !
#include <stdlib.h> //  utoa



//----     ----

//===   
// 
#define lcd_RS_PORT PORTC
#define lcd_RS_DDR DDRC
#define lcd_RS PC5
#define lcd_E_PORT PORTC
#define lcd_E_DDR DDRC
#define lcd_E PC4
#define lcd_RW_PORT PORTD
#define lcd_RW_DDR DDRD
#define lcd_RW PD0
//  
#define lcd_DB4_PORT PORTD // 
#define lcd_DB5_PORT PORTD
#define lcd_DB6_PORT PORTD 
#define lcd_DB7_PORT PORTD 
#define lcd_DB4_PIN PIND   // 
#define lcd_DB5_PIN PIND
#define lcd_DB6_PIN PIND 
#define lcd_DB7_PIN PIND 
#define lcd_DB4_DDR DDRD   //  
#define lcd_DB5_DDR DDRD
#define lcd_DB6_DDR DDRD 
#define lcd_DB7_DDR DDRD
#define lcd_DB4 PD1        // 
#define lcd_DB5 PD2
#define lcd_DB6 PD3
#define lcd_DB7 PD4
#define lcd_delay 20       //  E  LCD, 


void set_lcd_DATA_PORT (unsigned d)
//     
{
lcd_DB4_PORT &= ~(1 << lcd_DB4); //    
lcd_DB5_PORT &= ~(1 << lcd_DB5);
lcd_DB6_PORT &= ~(1 << lcd_DB6);
lcd_DB7_PORT &= ~(1 << lcd_DB7);
lcd_DB4_PORT |= (((d >> 0) & 1) << lcd_DB4);
lcd_DB4_PORT |= (((d >> 1) & 1) << lcd_DB5);
lcd_DB4_PORT |= (((d >> 2) & 1) << lcd_DB6);
lcd_DB4_PORT |= (((d >> 3) & 1) << lcd_DB7);
}


void lcd_busy (void)
//    4- 
{
lcd_DB4_DDR &= ~(1 << lcd_DB4); //    
lcd_DB5_DDR &= ~(1 << lcd_DB5);
lcd_DB6_DDR &= ~(1 << lcd_DB6);
lcd_DB7_DDR &= ~(1 << lcd_DB7);
lcd_RS_PORT &= ~(1 << lcd_RS);  //RS = 0
lcd_RW_PORT |= (1 << lcd_RW);   //R/W = 1 - 
unsigned char flag = 1;
while (flag)
  {
  lcd_E_PORT  |= (1 << lcd_E);  //E = 1   -   
  _delay_us (lcd_delay);
  flag = ((lcd_DB7_PIN & (1 << lcd_DB7)) >> lcd_DB7);
  lcd_E_PORT &= ~(1 << lcd_E);  //E = 0
  _delay_us (lcd_delay);
  lcd_E_PORT  |= (1 << lcd_E);  //E = 1   -    
  _delay_us (lcd_delay);
  lcd_E_PORT &= ~(1 << lcd_E);  //E = 0
  _delay_us (lcd_delay);
  }
lcd_DB4_DDR |= (1 << lcd_DB4); //    
lcd_DB5_DDR |= (1 << lcd_DB5);
lcd_DB6_DDR |= (1 << lcd_DB6);
lcd_DB7_DDR |= (1 << lcd_DB7);
lcd_RW_PORT &= ~(1 << lcd_RW);
}


void lcd_com (unsigned char b)
//     4- 
{
lcd_busy ();
lcd_RS_PORT &= ~(1 << lcd_RS); //RS = 0 - 
lcd_RW_PORT &= ~(1 << lcd_RW); //R/W = 0 - 
set_lcd_DATA_PORT (b >> 4);    //  
lcd_E_PORT |= (1 << lcd_E);    //E = 1 -  
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);   //E = 0 -    
_delay_us (lcd_delay);
set_lcd_DATA_PORT (b & 0x0F);  //  
lcd_E_PORT |= (1 << lcd_E);    //E = 1 -  
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);   //E = 0 -    
}


void lcd_dat (unsigned char b)
//     4- 
{
lcd_busy ();
lcd_RS_PORT |= (1 << lcd_RS);  //RS = 1 - 
lcd_RW_PORT &= ~(1 << lcd_RW); //R/W = 0 - 
set_lcd_DATA_PORT (b >> 4);    //  
lcd_E_PORT |= (1 << lcd_E);    //E = 1 -  
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);   //E = 0 -    
_delay_us (lcd_delay);
set_lcd_DATA_PORT (b & 0x0F);  //  
lcd_E_PORT |= (1 << lcd_E);    //E = 1 -  
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);   //E = 0 -    
}


void lcd_clr (void)
//  
{
lcd_com (0x01); // 
_delay_ms(5);   //>= 1,5 ms
}


void lcd_ini (void)
//  
{
//    
lcd_RS_DDR |= (1 << lcd_RS);
lcd_E_DDR  |= (1 << lcd_E);
lcd_RW_DDR |= (1 << lcd_RW);
lcd_DB4_DDR |= (1 << lcd_DB4);
lcd_DB5_DDR |= (1 << lcd_DB5);
lcd_DB6_DDR |= (1 << lcd_DB6);
lcd_DB7_DDR |= (1 << lcd_DB7);
//
lcd_E_PORT &= ~(1 << lcd_E);
_delay_ms(50); //    > 40 ms
//   0x30    8-  
lcd_RS_PORT &= ~(1 << lcd_RS); //RS = 0 - 
lcd_RW_PORT &= ~(1 << lcd_RW); //R/W = 0 - 
set_lcd_DATA_PORT (0x03);
lcd_E_PORT |= (1 << lcd_E);
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);   // 1- 
_delay_ms(5); // > 4,1 ms
lcd_E_PORT |= (1 << lcd_E);
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);   // 2- 
_delay_us(150); // > 100 us
lcd_E_PORT |= (1 << lcd_E);
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);   // 3- 
_delay_us (lcd_delay);
//    8- 
// 4-    0x20
set_lcd_DATA_PORT (0x02);
lcd_E_PORT |= (1 << lcd_E);
_delay_us (lcd_delay);
lcd_E_PORT &= ~(1 << lcd_E);
//    4- 
lcd_com (0x28); //4 , 2 
lcd_com (0x08); // 
lcd_clr ();     // 
lcd_com (0x02); //    Home
lcd_com (0x06); //  ;    - 
lcd_com (0x0C); // ,  
}


void lcd_cur (unsigned char row, unsigned char col)
//    row,  col,   0
{
unsigned char addr; // DDRAM (   )
addr = col;
if (row & 0b00000010) addr += 20;
if (row & 0b00000001) addr |= 0x40;
lcd_com (0x80 | addr); //   DDRAM
}


void lcd_str (char *str)
//    
{
unsigned int i = 0;
while (str[i])
   {
   char s = str[i++];
   lcd_dat (s);
   }
}



/*      : lcd_hex_byte  lcd_hex_int 

unsigned char nibble_char (unsigned char b)
//   
{
b &= 0x0F; 
if (b < 10)
   return (b+48); //
else
   return (b+55); //
}


void lcd_hex_byte (unsigned char b)
//  b     
{
lcd_dat (nibble_char (b >> 4));
lcd_dat (nibble_char (b));
}


void lcd_hex_int (unsigned int i)
//  i     
{
lcd_hex_byte (i >> 8);
lcd_hex_byte (i);
}

*/




void lcd_usg (unsigned char n, const unsigned char *usg)
//    n     
{
lcd_com (0x40); //   CGRAM     0x00
for (unsigned char i=0; i < ((((n - 1) & 7) + 1) << 3); i++) // n*8  
	lcd_dat (usg[i]); //  CGRAM        CGRAM
lcd_com (0x80); //   DDRAM      
}


//    
#define rectang_r_sym 0x00 //    , ""
#define rectang_l_sym 0x01 //    , ""
#define rectang_sym   0x02 //   ,  ""
#define speaker_sym   0x03 //
#define micro_sym     0x04 // ""
#define select_sym    0x05 //  


//    ( 8   )
const unsigned char usr_sym_n = 6; //   
const unsigned char usr_sg[] = {0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,  // 0x00 - " "
                                0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,  // 0x01 - " "
                                0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x00,  // 0x02 - " "
                                0x01,0x03,0x1D,0x15,0x1D,0x03,0x01,0x00,  // 0x03 - ""
                                #ifdef lcd4002
                                  #ifdef rus4002
                                0x00,0x00,0x14,0x1D,0x16,0x15,0x15,0x00,  // 0x04 - ""
                                  #else
                                0x00,0x12,0x12,0x12,0x12,0x1D,0x10,0x10,  // 0x04 - "u" ()
                                  #endif
                                #else
                                0x00,0x12,0x12,0x12,0x12,0x1D,0x10,0x10,  // 0x04 - "u" ()
                                #endif
								0x01,0x05,0x09,0x1F,0x08,0x04,0x00,0x00}; // 0x05 - "Enter" 


#ifdef lcd4002
   #ifdef rus4002
   //     4002
   #define l_sym  0xA7 //
   #define r_sym  0xA8 //
   #define u_sym  micro_sym //
   #define m_sym  0xBC //
   #define w1_sym 'B'  //
   #define w2_sym 0xBF //
   #define d1_sym 0xE3 //
   #define d2_sym 0xA0 //
   #else
   //     4002
   #define l_sym  'L'
   #define r_sym  'R'
   #define u_sym  micro_sym //
   #define m_sym  'm'
   #define w_sym  'W'
   #define d1_sym 'd'
   #define d2_sym 'B'
   #endif
#else
   //     1602
   #define l_sym  'L'
   #define r_sym  'R'
   #define u_sym  micro_sym //
   #define m_sym  'm'
   #define w_sym  'W'
   #define d1_sym 'd'
   #define d2_sym 'B'
#endif								



//----     ----

//===   

#define ADC_L 3 //    (ADC3)
#define ADC_R 0 //    (ADC0)
#define ADC_ref (1 <<REFS1) | (1 << REFS0) //   +2,54V


void ADC_ini (void)
// 
{
//ADCSRA = (1 << ADEN) | (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0); //128
ADCSRA = (1 << ADEN) | (1 << ADPS2) | (1 << ADPS1); //64 => 125 
ADMUX = ADC_ref;
}


void ADC_delay (void)
//   
{
//_delay_us (500);
_delay_us (200);
}


void ADC_left (void)
//   
{
ADMUX = ADC_ref | ADC_L; 
}


void ADC_right (void)
//   
{
ADMUX = ADC_ref | ADC_R; 
}


void ADC_start (void)
// 
{
ADCSRA |= (1 << ADSC);
}


void ADC_stop (void)
// 
{
ADCSRA &= ~(1 << ADSC);
}



//----     ----

//     ,   
//  . ""        ,
//""   .       
//      .  
//         .

#define flag_S_jmp_PORT PORTB //     
#define flag_S_jmp_PIN  PINB
#define flag_S_jmp_DDR  DDRB
#define flag_S_jmp PB1
#define flag_W_jmp_PORT PORTB //     
#define flag_W_jmp_PIN  PINB
#define flag_W_jmp_DDR  DDRB
#define flag_W_jmp PB2
#define flag_NoVal_jmp_PORT PORTB //    
#define flag_NoVal_jmp_PIN PINB
#define flag_NoVal_jmp_DDR DDRB
#define flag_NoVal_jmp PB6
unsigned char noval_flag; // ,      

#define max_code 1023  //       U = 0..Vref

#define F_clc 8            //  , 
#define T1_delay 100       //   T1, 
#define T1_preset (65536 - T1_delay * 256l / F_clc) //    T1
#define float_delay 1000   //  , 
#define float_count_max  float_delay / T1_delay //  T1    float_delay
unsigned int float_count_l = 0; //      
unsigned int float_count_r = 0; //      
unsigned char float_flag_l = 0; //     
unsigned char float_flag_r = 0; //     
unsigned char x_l = 0;  //  x     1..n; 0 - 
unsigned char x_r = 0;  //  x     1..n; 0 - 
unsigned char x1_l = 0; //  x    
unsigned char x1_r = 0; //  x    
unsigned float_x_l = 0; //   
unsigned float_x_r = 0; //   
unsigned int code_l = 0; //    
unsigned int code_r = 0; //    

#define x0 2             //     
#define sc_zn   (cols - x0 - vlen) //      
#define sc_zn_f (cols - x0)        //      

#ifdef lcd4002           // 4002
   #define cols 40       //   
   #ifdef rus4002
      #define vlen 6     //     
      #define n1 (2 * sc_zn) //64 -         
   #else
      #define vlen 5     //     
      #define n1 (2 * sc_zn) //66 -        
   #endif
   #define n2 (2 * sc_zn_f)  //76 -       
#else                    // 1602
   #define cols 16       //   
   #define vlen 4        //     
   #define n1 (2 * sc_zn)   //20 -       
   #define n2 (2 * sc_zn_f) //28 -       
#endif


unsigned char n;        //n1  n2


#ifdef lcd4002 // 4002
//           40  60 
unsigned int level [76]; //unsigned int level [n2];
//        40  60 
//  -   4 ;   -  
   #ifdef rus4002
      char power_val [n1+1][4]; //char power_val [65][4]; 
   #else
      char power_val [n1+1][4]; //char power_val [67][4];
   #endif
//        40  60 
//  -   3 ;   -  
   #ifdef rus4002
      char db_val [n1+1][3]; //char db_val [65][3];
   #else
      char db_val [n1+1][3]; //char db_val [67][3];
   #endif
#else // 1602
//          40  60 
unsigned int level [2*n2]; //unsigned int level [56];
//       40  60 
//  -   4 ;   -  
char power_val [2*(n1+1)][4]; //char power_val [42][4];
//       40  60 
//  -   3 ;   -  
char db_val [2*(n1+1)][3]; //char db_val [42][3];
#endif


//          40  60 
#ifdef lcd4002 // 4002
  #define d0  40.0/(n1-1) //0.65-         
  #define d1  60.0/(n1-1) //0.9 -         
  #define d0f 40.0/(n2-1) //0.55-          (full)
  #define d1f 60.0/(n2-1) //0.8 -         
#else          // 1602
  #define d0  40.0/(n1-1) //2.0 -         
  #define d1  60.0/(n1-1) //3.0 -         
  #define d0f 40.0/(n2-1) //1.5 -         
  #define d1f 60.0/(n2-1) //2.1 -         
#endif

#define k0 pow (10,d0/20)   //        
#define k1 pow (10,d1/20)   //        
#define k0f pow (10,d0f/20) //         (full)
#define k1f pow (10,d1f/20) //        



unsigned char check_flag_S (void)
//     (-3    )
{
return (!(flag_S_jmp_PIN & (1 << flag_S_jmp)));
}


unsigned char check_flag_W (void)
//      
{
return (!(flag_W_jmp_PIN & (1 << flag_W_jmp)));
}


unsigned char check_flag_NoVal (void)
//     
//      
{
return (!(flag_NoVal_jmp_PIN & (1 << flag_NoVal_jmp)));
}


void scale_ini ()
// 
{
lcd_clr ();
cli (); // 
x_l = 0; x_r = 0; x1_l = 0; x1_r = 0; float_x_l = 0; float_x_r = 0;
float_count_l = 0; float_count_r = 0; float_flag_l = 0; float_flag_r = 0;
sei ();  // 
//  
lcd_cur (0,0);
lcd_dat (l_sym); //L
lcd_dat (speaker_sym); //
lcd_cur (1,0);
lcd_dat (r_sym); //R
lcd_dat (speaker_sym);
//    x0
flag_S_jmp_DDR  &= ~(1 << flag_S_jmp); //    
flag_S_jmp_PORT |=  (1 << flag_S_jmp);
flag_W_jmp_DDR  &= ~(1 << flag_W_jmp);
flag_W_jmp_PORT |=  (1 << flag_W_jmp);
flag_NoVal_jmp_DDR  &= ~(1 << flag_NoVal_jmp);
flag_NoVal_jmp_PORT |=  (1 << flag_NoVal_jmp);
}


void disp_float (unsigned char y, unsigned char x, unsigned char float_x)
//    float_x      (y,x)
//      2  
{
if (x < float_x) //      ,   
   {
   unsigned char x_lcd = (x+1) >> 1; //     
   unsigned char float_x_lcd = (float_x+1) >> 1; //    
   if (x_lcd < float_x_lcd) //        
	  {
      lcd_cur (y, x0+float_x_lcd-1);
	  if (float_x & 0x01) //    
	     lcd_dat (rectang_l_sym); // 
	  else   //    
         lcd_dat (rectang_r_sym); // 
	  }
   else
      if (x_lcd == float_x_lcd) //       
	     { //,    
         lcd_cur (y, x0+float_x_lcd-1);
	     if (float_x & 0x01) //    
	        lcd_dat (rectang_l_sym); // 
	     else   //    
            lcd_dat (rectang_sym);   // 
	     }		   
   }
}


void blank_float (unsigned char y, unsigned char x, unsigned char float_x)
//    float_x      (y,x)
//      2  
//     0,  -   1,  - 2
{
if (x < float_x) //      ,   
   {
   unsigned char x_lcd = (x+1) >> 1; //     
   unsigned char float_x_lcd = (float_x+1) >> 1; //    
   if (x_lcd < float_x_lcd) //        
	  {
      lcd_cur (y, x0+float_x_lcd-1);
      lcd_dat (' '); //  
	  }
   else
      if (x_lcd == float_x_lcd) //       
	     {
         lcd_cur (y, x0+float_x_lcd-1);
         lcd_dat (rectang_l_sym); //  -  ,  
	     }		   
   }
}



void disp_power (unsigned char y, unsigned char x)
//       y
//      x=0..n
//  1602:
//   ,   ,
// 5 ,   - 4 .
//  4002:
// 5   6  .
//    ,   !
{
#ifdef lcd4002
   #ifdef rus4002
      char power_str [vlen+1]; //vlen+1=7 -      
   #else
      char power_str [vlen+1]; //vlen+1=6 -      
   #endif
#else //1602
   char power_str [vlen+2]; //vlen+2=6 -   5- 
#endif
	
if (x > n) x = n;
unsigned char j = x;

#ifndef lcd4002
if (check_flag_S ())
   j += n+1; //     -   1602
#endif

if (check_flag_W ())
   { //W
   char * ptr = power_val [j];
   //       power_str
   #ifdef lcd4002 // 4002
   
      for (unsigned char i = 0; i < 4; i++) power_str[i] = * ptr++; //4 
      #ifdef rus4002 //
	  if (x > 0)
         {
         power_str[4] = w1_sym; //  "",    
         power_str[5] = w2_sym; 
         }
      else //   
         {
         power_str[4] = ' ';
         power_str[5] = ' ';
         }
      power_str[6] = 0; //vlen=6 -      
      lcd_cur (y, cols-vlen);
      #else          //
	  if (x > 0)
         power_str[4] = w_sym; //  "W",    
      else //   
         power_str[4] = ' ';
      power_str[5] = 0; //vlen=5 -      
      lcd_cur (y, cols-vlen);
      #endif
  
   #else // 1602
	   
   if (x < n-1)
      {
      for (unsigned char i = 0; i < 4; i++) power_str[i] = * ptr++; //4 
	  if (x > 0)
         power_str[4] = w_sym; //  "W",    
      else //   
         power_str[4] = ' ';
      power_str[5] = 0; //vlen+1=5 -      
      lcd_cur (y, cols-vlen-1);
      }
   else //   
      {
      power_str[0] = * ptr++; //    1-  
      for (unsigned char i = 0; i < 3; i++) power_str[i] = * ptr++; //3 
	  power_str[3] = w_sym; //  "W"
      power_str[4] = 0; //vlen=4 -      
      lcd_cur (y, cols-vlen);
      }
	#endif
	
   }
else
   { //dB
   char * ptr = db_val [j];
   //       power_str
   #ifdef lcd4002 // 4002
   
      #ifdef rus4002 //
	  power_str[0] = ' '; //       
      for (unsigned char i = 0; i < 3; i++) power_str[i+1] = * ptr++; //3 
      if (x > 0)
	     {
         power_str[4] = d1_sym; //  "dB",    
         power_str[5] = d2_sym;
		 } 
      else //   
	     {
         power_str[4] = ' ';
         power_str[5] = ' ';
		 }
      power_str[6] = 0; //vlen=6 -      
      lcd_cur (y, cols-vlen);
      #else          //
      for (unsigned char i = 0; i < 3; i++) power_str[i] = * ptr++; //3 
      if (x > 0)
	     {
         power_str[3] = d1_sym; //  "dB",    
         power_str[4] = d2_sym;
		 } 
      else //   
	     {
         power_str[3] = ' ';
         power_str[4] = ' ';
		 }
      power_str[5] = 0; //vlen=5 -      
      lcd_cur (y, cols-vlen);
      #endif
  
   #else // 1602

   if (x < n-1)
      {
      for (unsigned char i = 0; i < 3; i++) power_str[i] = * ptr++; //3 
      if (x > 0)
	     {
         power_str[3] = d1_sym; //  "dB",    
		 power_str[4] = d2_sym;
		 } 
      else //   
	     {
         power_str[3] = ' ';
		 power_str[4] = ' ' ;
		 }
      power_str[5] = 0; //vlen+1=5 -      
      lcd_cur (y, cols-vlen-1);
      }
   else //   
      {
      power_str[0] = * ptr++; //    1-  
      for (unsigned char i = 0; i < 2; i++) power_str[i] = * ptr++; //2 
      power_str[2] = d1_sym;
      power_str[3] = d2_sym;
      power_str[4] = 0; //vlen=4 -      
      lcd_cur (y, cols-vlen);
      }	  
	#endif
	
   }
lcd_str (power_str);
}


unsigned char calc_pos (unsigned int code)
//  0..n       code=0..max_code
{
unsigned char i;
if (code > max_code) code = max_code;
//      

#ifdef lcd4002

for (i = 0; (i < n) && (level[i] <= code); i++);

#else //1602

if (check_flag_S ())
   for (i = 0; (i < n) && (level[i+n] <= code); i++);
else
   for (i = 0; (i < n) && (level[i] <= code); i++);

#endif

// i = 0,     ,
//   i  (i=1..n)
return (i);
}


unsigned char disp_pos (unsigned int code, unsigned char y1, unsigned char x1)
//    code 
// (y1,x1)    
//  -   x
{
unsigned char x = calc_pos (code); //  x  
signed char dx = x - x1; //  x  
unsigned char x_lcd = (x + 1) >> 1;   //      
unsigned char x1_lcd = (x1 + 1) >> 1; //      
signed char dx_lcd = x_lcd - x1_lcd;  //  x  
if (dx < 0) //     
   {
   if (dx_lcd < 0) //        
      {
	  lcd_cur (y1,x0+x_lcd);
      for (unsigned char j = 0; j < -dx_lcd; j++)
        { lcd_dat (' '); } // "" 
	  if (x & 0x01) //   x -  (  >= 1   x_lcd >= 1)
	     {
		 lcd_cur (y1,x0+x_lcd-1);
		 lcd_dat (rectang_l_sym); //     
	     }		  
	  }
   else
      if (dx_lcd == 0) //      
	     {
		 lcd_cur (y1,x0+x_lcd-1); // x_lcd = x1_lcd >= 1,   x1 >= 1
		 lcd_dat (rectang_l_sym); //     
	     }   
   }
else
   if (dx > 0) //    
      {
	  if (dx_lcd > 0) //        
	     {
			 if (x1 & 0x01) //   - ,     
			    {
				lcd_cur (y1,x0+x1_lcd-1); //x1_lcd >= 1,   x1    x1 >= 1
				lcd_dat (rectang_sym); //   
		        }
	     lcd_cur (y1,x0+x1_lcd);
	     for (unsigned char j = 0; j < dx_lcd; j++) 
	       { lcd_dat (rectang_sym); } //  
	     if (x & 0x01) //   - 
		    {
		    lcd_cur (y1,x0+x_lcd-1); // x_lcd >= 1,   x    x >= 1
		    lcd_dat (rectang_l_sym); //     
			}
         }
	  else
         if (dx_lcd == 0) //      
		    {
		    lcd_cur (y1,x0+x_lcd-1); // x_lcd >= 1,   dx > 0   x >= 1
		    lcd_dat (rectang_sym);   //     
		    }
	  }
return (x);
}



void timer1_start (void)
//  1
{
TCCR1B = 0; //  1
TCNT1 = T1_preset; //  T1  
TCCR1B |= (1 << CS12); //  1   256
}


void timer1_ini (void)
//  1
{
timer1_start ();
TIMSK  |= (1 << TOIE1); //     1
}


ISR (TIMER1_OVF_vect)
//===     16-  1
//        
{
float_count_l++; 
if (float_count_l > float_count_max)
   {
   float_count_l = 0;
   float_flag_l = 1; 
   }
float_count_r++;
if (float_count_r > float_count_max)
   {
   float_count_r = 0;
   float_flag_r = 1; 
   }
timer1_start ();
}




//----     ----

#define Pmax_0 100              //    , 
unsigned int Pmax = Pmax_0;     //  
uint16_t eeprom_Pmax EEMEM;     // Pmax  EEPROM
uint16_t eeprom_Pctr EEMEM;     //   Pmax


void read_eeprom (void)
//   EEPROM  Pmax
{
uint16_t p = eeprom_read_word (&eeprom_Pmax);
uint16_t c = eeprom_read_word (&eeprom_Pctr);
if (((p < 1) || (p > 999)) || ((p + 5) != c)) // 
   Pmax = Pmax_0;
else
   Pmax = p;
}


void write_eeprom (void)
//  EEPROM   Pmax
{
uint16_t p = Pmax;   //  Pmax
uint16_t c = Pmax+5; // 
eeprom_update_word (&eeprom_Pmax,p);
eeprom_busy_wait (); //     EEPROM
eeprom_update_word (&eeprom_Pctr,c);
eeprom_busy_wait (); //     EEPROM
}



void Pow2Str (double P, char * Buf)
//  Buf   4      P, 
{
wdt_reset ();
char s[3]; //      < 1000
double rP = round (P);
Buf[0] = ' ';
if (rP > 999) //
   {
   Buf[1] = 'X';
   Buf[2] = 'X';
   Buf[3] = 'X';
   }
else
   {
   if (rP < 100) // 100 
      if (rP < 10) // 10 
	     {
		 P = P * 10;
		 rP = round (P);
         if (rP < 10)   // 1 
		    {
		    P = P * 10;
		    rP = round (P);
	        if (rP < 10)  // 100 
			    {
		        P = P * 10;
		        rP = round (P);
		        if (rP < 10)  // 10 
				   { 
		           P = P * 10;
		           rP = round (P);
			       if (rP < 10)  // 1 
				      {
		              P = P * 10;
		              rP = round (P);
				      if (rP < 10) // 100 
					     {
		                 P = P * 10;
		                 rP = round (P);
				         if (rP < 10) // 10 
				            {
					        utoa (rP,s,10); //0..9 
                            Buf[1] = ' ';
                            Buf[2] = s[0];
                            Buf[3] = u_sym;
					        }
                         else //  10   100 
						    {
					        utoa (rP,s,10); //10..99 
                            Buf[1] = s[0];
                            Buf[2] = s[1];
                            Buf[3] = u_sym;
							}
                         }
                      else //  100   1000 
					     {
					     utoa (10*round(P/10),s,10); //0,1..0,9  -    
                         Buf[0] = '0';
                         Buf[1] = '.';
                         Buf[2] = s[0];
                         Buf[3] = m_sym;
						 }
                      }
                   else //  1   10 
				      {
				      utoa (rP,s,10); //1,0..9,9 
                      Buf[0] = s[0];
                      Buf[1] = '.';
                      Buf[2] = s[1];
                      Buf[3] = m_sym;
					  }
                   }
                else //  10   100 
				   {
				   utoa (rP,s,10); //10..99 
                   Buf[1] = s[0];
                   Buf[2] = s[1];
                   Buf[3] = m_sym;
				   }
               }
            else //  100   1000 
			   {
			   utoa (rP,s,10); //0,10..0,99 
			   Buf[0] = '0';
			   Buf[1] = '.';
               Buf[2] = s[0];
               Buf[3] = s[1];
			   }
            }
         else //  1   10 
		    {
			utoa (rP,s,10); //1,0..9,9 
            Buf[1] = s[0];
			Buf[2] = '.';
            Buf[3] = s[1];
			}
		 }
      else //  10   100 
	     {
		 utoa (rP,s,10); //10..99 
         Buf[1] = ' ';
		 Buf[2] = s[0];
         Buf[3] = s[1];
		 }
   else //  100   1000 
      {
	  utoa (rP,s,10); //100..999 
	  Buf[1] = s[0];
      Buf[2] = s[1];
      Buf[3] = s[2];
	  }
   }
}



void Db2Str (unsigned char D, char * Buf)
//  Buf   3     -D  
//  -      
{
wdt_reset ();
char s[3]; //      < 100
Buf[0] = ' ';
if (D == 0)
   {
   Buf[1] = ' ';
   Buf[2] = '0'; 
   }
else
   if (D < 10)
      {
	  utoa (D,s,10);
	  Buf[1] = '-';
	  Buf[2] = s[0];
	  } 
   else
      if (D < 100)
	     {
	     utoa (D,s,10);
	     Buf[0] = '-';
	     Buf[1] = s[0];
	     Buf[2] = s[1];
	     }
      else
	     { //
		 Buf[0] = '-';
		 Buf[1] = 'X';
		 Buf[2] = 'X';
		 }
}




void tables1_ini (void)
//       
{
#ifdef lcd4002 // 4002
  double kx = round (max_code);
  double k, kf;
  if (check_flag_S()) //  
     { k = k1; kf = k1f; }
  else
     { k = k0; kf = k0f; }
#else // 1602
  double kx_0 = round (max_code);
  double kx_1 = kx_0;
#endif

#ifdef lcd4002 // 4002
//            
if (!(noval_flag)) //   ; n=64
   {
   for (unsigned char i=n; i>0; i--)
     {
     //       
     level[i-1] = round (kx);
     kx = kx / k;
     } 
   }
else
   //    :        (n=76)
   {
   for (unsigned char i=n; i>0; i--)
     {
     //          
     level[i-1] = round (kx);
     kx = kx / kf;
     }
   }
#else // 1602
//    
if (!(noval_flag)) //   ; n=20
   {
   for (unsigned char i=n; i>0; i--)
     {
     //          
     level[i-1]   = round (kx_0); //  
     level[n+i-1] = round (kx_1); //  
     kx_0 = kx_0 / k0;
     kx_1 = kx_1 / k1;
     }
   }
else
   //    :        (n=28)
   {
   for (unsigned char i=n; i>0; i--)
     {
     //          
     level[i-1]   = round (kx_0); //  
     level[n+i-1] = round (kx_1); //  
     kx_0 = kx_0 / k0f;
     kx_1 = kx_1 / k1f;
     } 
   }
#endif
}



void tables2_ini (void)
//     
//  Pmax=1..999    , 
{
//         
double k0_2 = k0 * k0;
double k1_2 = k1 * k1;

#ifdef lcd4002 // 4002
  double px = round (Pmax);
#else // 1602
  double px_0 = round (Pmax);
  double px_1 = px_0;
#endif

#ifdef lcd4002  // 4002
//           
if (!(noval_flag)) //   ; n=64
   {
   //      
   power_val [0][0] = ' '; power_val [0][1] = ' '; power_val [0][2] = ' '; power_val [0][3] = ' ';
   for (unsigned char i=n; i>0; i--)
     {
     //      
     Pow2Str (px, power_val [i]);
     if (check_flag_S()) //  
        px = px / k1_2;  //   i   (1..n)
     else 
        px = px / k0_2;
     }
   }
#else // 1602
//     (   1602)
if (!(noval_flag)) //   ; n=20
   {
   //      
   power_val [0][0] = ' '; power_val [0][1] = ' '; power_val [0][2] = ' '; power_val [0][3] = ' ';
   power_val [n+1][0] = ' '; power_val [n+1][1] = ' '; power_val [n+1][2] = ' '; power_val [n+1][3] = ' ';
   for (unsigned char i=n; i>0; i--)
     {
     //      
     Pow2Str (px_0, power_val [i]);
     Pow2Str (px_1, power_val [i+n+1]);
     px_0 = px_0 / k0_2; //   i   (1..n)   
     px_1 = px_1 / k1_2; //   i   (1..n)   
     }
     if (Pmax == 1) //        5 : 0.50  0.63
        { //    
	    power_val [n-1][3] = power_val [n-1][2]; power_val [n-1][2] = power_val [n-1][1]; 
	    power_val [n-1][1] = power_val [n-1][0]; power_val [n-1][0] = ' ';
	    power_val [n+n][3] = power_val [n+n][2]; power_val [n+n][2] = power_val [n+n][1]; 
	    power_val [n+n][1] = power_val [n+n][0]; power_val [n+n][0] = ' ';
	    }
   }
#endif
}




void tables3_ini (void)
//     
{
#ifdef lcd4002 // 4002
  double dx = 0; //0 -    
  unsigned int dxr = round (dx); //0
#else          // 1602
  double dx_0 = 0; //0 -    
  double dx_1 = dx_0;
  unsigned char dx_0r = round (dx_0);
  unsigned char dx_1r = dx_0r;
#endif

#ifdef lcd4002  // 4002
if (!(noval_flag)) //   ; n=64
   {
   //      
   db_val [0][0] = ' '; db_val [0][1] = ' '; db_val [0][2] = ' '; 
   for (unsigned char i=n; i>0; i--)
     {
     //     
     Db2Str (dxr, db_val [i]);
     if (check_flag_S()) //  
        dx = dx + d1; 
     else
        dx = dx + d0;
     dxr = round (dx);
     }
   }
#else // 1602
//    
if (!(noval_flag)) //   ; n=20
   {
   //      
   db_val [0][0] = ' '; db_val [0][1] = ' '; db_val [0][2] = ' '; 
   db_val [n+1][0] = ' '; db_val [n+1][1] = ' '; db_val [n+1][2] = ' ';
   for (unsigned char i=n; i>0; i--)
     {
     //     
     Db2Str (dx_0r, db_val [i]);
     Db2Str (dx_1r, db_val [i+n+1]);
     dx_0 = dx_0 + d0;
     dx_1 = dx_1 + d1;
     dx_0r = round (dx_0);
     dx_1r = round (dx_1);
     }
   }
#endif
}



void tables_ini (void)
//  
{
tables1_ini (); //       
tables2_ini (); //     
tables3_ini (); //     
}



//----     ----

//===   

#define but_minus_PORT PORTB
#define but_minus_PIN PINB
#define but_minus_DDR DDRB
#define but_minus PB5
#define but_plus_PORT PORTB
#define but_plus_PIN PINB
#define but_plus_DDR DDRB
#define but_plus PB3
#define but_select_PORT PORTB
#define but_select_PIN PINB
#define but_select_DDR DDRB
#define but_select PB4


#define change_val_delay 100   //    Pmax  -  +, 
#define key_pressed_delay 10   //    , 
#define key_check_count 5      //   
#define menu_select_delay 1000 //       , 
#define T0_ovf_delay  256l * (1024l / F_clc)  //     0, 
#define T0_ovf_count_max  menu_select_delay * 1000l / (T0_ovf_delay * 1l) // 
volatile unsigned char T0_ovf_count = 0; // 
volatile unsigned char select_long_press = 0; //    



void buttons_ini (void)
//   
{
but_minus_DDR   &= ~(1 << but_minus); //    
but_minus_PORT  |=  (1 << but_minus); //  
but_plus_DDR    &= ~(1 << but_plus);
but_plus_PORT   |=  (1 << but_plus);
but_select_DDR  &= ~(1 << but_select);
but_select_PORT |=  (1 << but_select);
}


unsigned char minus_pressed (void)
//   ""
{
return (!(but_minus_PIN & (1 << but_minus)));
}


unsigned char plus_pressed (void)
//   ""
{
return (!(but_plus_PIN & (1 << but_plus)));
}


unsigned char select_pressed (void)
//   ""
{
return (!(but_select_PIN & (1 << but_select)));
}


unsigned char minus_pressed_safe (void)
//""    ""  
{
unsigned char cycle = key_check_count; //   
while ((minus_pressed ()) && cycle)
  {
  _delay_ms (key_pressed_delay); //
  cycle--;
  }
return (cycle==0);
}


unsigned char plus_pressed_safe (void)
//""    ""  
{
unsigned char cycle = key_check_count;
while ((plus_pressed ()) && cycle)
  {
  _delay_ms (key_pressed_delay); 
  cycle--;
  }
return (cycle==0);
}


unsigned char select_pressed_safe (void)
//""    ""    
{
unsigned char res = select_long_press; //    
select_long_press = 0; //   ,   
return (res);
}


/*
unsigned char select_pressed_safe (void)
//""    ""  
{
unsigned char cycle = key_check_count;
while ((select_pressed ()) && cycle)
  {
  _delay_ms (key_pressed_delay); 
  cycle--;
  }
return (cycle==0);
}
*/



void timer0_start (void)
//  0
{
TCCR0 = 0;
TCNT0 = 0;
TCCR0 |= (1 << CS02) | (1 << CS00); //  0   1024
}


void timer0_ini (void)
//  0
{
timer0_start ();
TIMSK  |= (1 << TOIE0); //     0
}


ISR (TIMER0_OVF_vect)
//===     8-  0
//          
{
if (select_pressed ()) //  ""
   {
   T0_ovf_count++;
   if (T0_ovf_count > T0_ovf_count_max) // 
      {
      T0_ovf_count = 0;
      select_long_press = 1;
	  }
   }
else
   {
   T0_ovf_count = 0;
   select_long_press = 0;
   }
}


void pause (unsigned char dT)
// dT     
{
if ((dT > 0) && (dT < 25))
   for (unsigned char i=0; i < dT*10; i++) // 1 
      { wdt_reset (); _delay_ms (100); }
}


void out_Pmax_title (void)
//   Pmax
{
lcd_clr ();
//lcd_cur (0,2);
#ifdef lcd4002
  #ifdef rus4002
  lcd_cur (0,(cols-13)/2);
  lcd_dat ('P'); lcd_dat (0xBC); lcd_dat ('a'); lcd_dat (0xBA); lcd_dat ('c'); lcd_dat (' '); lcd_dat ('='); //P =
  #else
  lcd_cur (0,(cols-11)/2);
  lcd_dat ('P'); lcd_dat ('m'); lcd_dat ('a'); lcd_dat ('x'); lcd_dat (' '); lcd_dat ('='); //Pmax =
  #endif
#else
lcd_cur (0,(cols-11)/2);
lcd_dat ('P'); lcd_dat ('m'); lcd_dat ('a'); lcd_dat ('x'); lcd_dat (' '); lcd_dat ('='); //Pmax =
#endif
}


void out_menu (void)
//  
{
//lcd_cur (1,2);
#ifdef lcd4002
  #ifdef rus4002
  lcd_cur (1,(cols-13)/2);
  lcd_dat ('H');  //
  lcd_dat ('a');
  lcd_dat (0xB6); //
  lcd_dat (0xBC); //
  lcd_dat (0xB8); //
  lcd_dat (0xBF); //
  lcd_dat ('e');
  #else
  lcd_cur (1,(cols-11)/2);
  lcd_dat ('P'); //Press
  lcd_dat ('r');
  lcd_dat ('e');
  lcd_dat ('s');
  lcd_dat ('s');
  #endif
#else
lcd_cur (1,(cols-11)/2);
lcd_dat ('P'); //Press
lcd_dat ('r');
lcd_dat ('e');
lcd_dat ('s');
lcd_dat ('s');
#endif
lcd_dat (':');
lcd_dat (' ');
lcd_dat ('-');
lcd_dat (' ');
lcd_dat (select_sym);
lcd_dat (' ');
lcd_dat ('+');
}


void out_canceled (void)
//    
{
lcd_clr ();
//lcd_cur (0,4);
#ifdef lcd4002
  #ifdef rus4002
  lcd_cur (0,(cols-9)/2); //!
  lcd_dat ('O'); lcd_dat (0xBF); lcd_dat (0xBC); lcd_dat ('e'); lcd_dat (0xBD);
  lcd_dat ('e'); lcd_dat (0xBD); lcd_dat ('o'); lcd_dat ('!');
  #else
  lcd_cur (0,(cols-9)/2); //Canceled!
  lcd_dat ('C'); lcd_dat ('a'); lcd_dat ('n'); lcd_dat ('c'); lcd_dat ('e');
  lcd_dat ('l'); lcd_dat ('e'); lcd_dat ('d'); lcd_dat ('!');
  #endif
#else
lcd_cur (0,(cols-8)/2); //Canceled!
lcd_dat ('C'); lcd_dat ('a'); lcd_dat ('n'); lcd_dat ('c'); lcd_dat ('e');
lcd_dat ('l'); lcd_dat ('e'); lcd_dat ('d'); lcd_dat ('!');
#endif
}


void out_Pmax (unsigned int Pmax)
//  Pmax = 1..999 W
{
char s[6]; //  (  1602  4002en  5!)
if ((Pmax < 1) || (Pmax > 999))
   Pmax = 999;
utoa (Pmax,s,10);
unsigned char l = floor (log10 (Pmax))+1; // 
if (l > 3) l = 3;
#ifdef lcd4002
  #ifdef rus4002
  s [l]   = 'B';
  s [l+1] = 0xBF; //
  s [l+2] = 0; // 
  lcd_cur (0,(cols-13)/2+9);
  lcd_str (s);
  #else
  s [l] = 'W';
  s [l+1] = 0; // 
  lcd_cur (0,(cols-11)/2+8);
  lcd_str (s);
  #endif
#else
s [l] = 'W';
s [l+1] = 0; // 
//lcd_cur (0,10);
lcd_cur (0,(cols-11)/2+8);
lcd_str (s);
#endif
}



void Pmax_change (void)
//   Pmax
{
cli (); // 
unsigned int P = Pmax; //  Pmax
out_Pmax_title ();
out_Pmax (P);
out_menu ();
lcd_com (0x0D); //    
//lcd_cur (0,10);
#ifdef lcd4002
  #ifdef rus4002
  lcd_cur (0,(cols-13)/2+9);
  #else
  lcd_cur (0,(cols-11)/2+8);
  #endif
#else
lcd_cur (0,(cols-11)/2+8);
#endif
while (select_pressed ()) { wdt_reset (); } //  
unsigned char cancel = 0; //    Pmax
sei (); //      
//   Pmax   
while ( (!(select_pressed_safe())) && (!cancel) )
  {
  if (minus_pressed_safe ())
	 {
	 if ( (plus_pressed ()) || (select_pressed ()) ) // -    
		cancel = 1;
     else
	    {
		cli ();
		if (P > 1) P = P - 1;
	    //lcd_cur (0,10);
        #ifdef lcd4002
          #ifdef rus4002
          lcd_cur (0,(cols-13)/2+9);
          #else
          lcd_cur (0,(cols-11)/2+8);
          #endif
        #else
        lcd_cur (0,(cols-11)/2+8);
        #endif
        lcd_dat (' '); lcd_dat (' '); lcd_dat (' '); lcd_dat (' ');
        lcd_dat (' '); // 4002    
	    out_Pmax (P);
	    //lcd_cur (0,10);
        #ifdef lcd4002
          #ifdef rus4002
          lcd_cur (0,(cols-13)/2+9);
          #else
          lcd_cur (0,(cols-11)/2+8);
          #endif
        #else
        lcd_cur (0,(cols-11)/2+8);
        #endif
		_delay_ms (change_val_delay);
		sei ();
		}
	 }
  if (plus_pressed_safe ())
	 {
	 if ( (minus_pressed ()) || (select_pressed ()) ) // -    
		cancel = 1;
     else
	    {
		cli ();
		if (P < 999) P = P + 1;
	    out_Pmax (P);
	    //lcd_cur (0,10);
        #ifdef lcd4002
          #ifdef rus4002
          lcd_cur (0,(cols-13)/2+9);
          #else
          lcd_cur (0,(cols-11)/2+8);
          #endif
        #else
        lcd_cur (0,(cols-11)/2+8);
        #endif
		_delay_ms (change_val_delay);
		sei ();
		}
     }
  wdt_reset ();
  } //  
cli (); // 
//  Pmax 
lcd_com (0x0C); //    
if (cancel)
   out_canceled (); // -  
else
   {
   Pmax = P;
   write_eeprom ();   //   Pmax  
   tables_ini ();     // 
   out_Pmax_title ();
   out_Pmax (Pmax);   //   Pmax   
   lcd_dat (' '); lcd_dat ('!');
   }
while (select_pressed ()) { wdt_reset (); } //  
pause (1);    // 1 
scale_ini (); //    
sei (); // 
}




//========================================================
int main (void)
{

cli ();
noval_flag = check_flag_NoVal (); //     
if (noval_flag)  n = n2; else n = n1;

wdt_enable (WDTO_250MS); //  
ADC_ini ();     // 
lcd_ini ();     // 
lcd_usg (usr_sym_n, usr_sg); //   
read_eeprom (); //  Pmax  EEPROM
tables_ini ();  //   Pmax
buttons_ini (); // 
timer0_ini ();  //  0
timer1_ini ();  //  1
if (check_flag_W () && !(noval_flag))
   { //    
   out_Pmax_title ();
   //lcd_cur (0,10);
   #ifdef lcd4002
     #ifdef rus4002
     lcd_cur (0,(cols-13)/2+9);
     #else
     lcd_cur (0,(cols-11)/2+8);
     #endif
   #else
   lcd_cur (0,(cols-11)/2+8);
   #endif
   out_Pmax (Pmax);
   pause (2);    //   Pmax (  wdt)
   scale_ini (); //   
   }
else
   {
   scale_ini (); //   
   pause (1);    //     (  wdt)
   }

sei ();

while (1) 
   {

   //       
   ADC_left ();   //    
   ADC_start ();  //     
   ADC_delay ();  //  
   ADC_stop ();   // 
   code_l = ADC;  //    
   ADC_right ();  //    
   ADC_start ();  //     
   ADC_delay ();  //  
   ADC_stop ();   // 
   code_r = ADC;  //    
   
   cli (); //     

   //      
   x_l = disp_pos (code_l, 0, x1_l); // 
   x_r = disp_pos (code_r, 1, x1_r);
   x1_l = x_l; x1_r = x_r; //  


   //       
   if (x_l > float_x_l) //   
      {
	  float_count_l = 0; //    
	  float_flag_l = 0;
      //    
	  if (!(noval_flag)) disp_power (0, x_l);
	  //    (      )
	  float_x_l = x_l;
	  }
   else
      if (x_l < float_x_l) //   
	     {
         if (float_flag_l) //   
            {
			float_count_l = 0;  //    
			float_flag_l = 0;
           //       
            blank_float (0, x_l, float_x_l);
            if (!(noval_flag)) disp_power (0, x_l);
	        //    (      )
	        float_x_l = x_l;
			}
         else
			//  ,       
            disp_float (0, x_l, float_x_l);
		 }

   //       
   if (x_r > float_x_r) //   
      {
	  float_count_r = 0; //    
	  float_flag_r = 0;
      //    
	  if (!(noval_flag)) disp_power (1, x_r);
	  //    (      )
	  float_x_r = x_r;
	  }
   else
      if (x_r < float_x_r) //   
	     {
         if (float_flag_r) //   
            {
			float_count_r = 0; //    
			float_flag_r = 0;
            //       
            blank_float (1, x_r, float_x_r);
            if (!(noval_flag)) disp_power (1, x_r);
	        //    (      )
	        float_x_r = x_r;
			}
         else
			//  ,       
            disp_float (1, x_r, float_x_r);
		 }

   sei (); // 

   //       Pmax
   if (select_pressed_safe() && !(noval_flag)) //  
      Pmax_change (); //    Pmax

   _delay_ms(20); //       
   wdt_reset ();  //  

   } //while (1)

}
